INCLUDE MACROS80.ASM
; ========================================================================
; ------------------------------------------------------------------------
;  ⠭:
; ------------------------------------------------------------------------
;
;  ᪠ ணࠬ    

CONST:

  RAM_BASE    EQU 04000h    ;  ᪠  
  ROM_BASE    EQU 0F800h    ;  ᪠  
  IO_BASE     EQU 0C8h      ;  ணࠬ㥬 䥩
  CT_BASE     EQU 074h      ;  ⠩


; ------------------------------------------------------------------------
;  ணࠬ㥬 䥩 IO
; ------------------------------------------------------------------------
;  ࠡ ணࠬ㥬 䥩 -   ﭨ

  IOSB_SETMODE    EQU 10000000b      ; IO STATUS BITS
  IOSB_SETCBITS   EQU 00000000b
  IOSB_AMODE0     EQU 00000000b
  IOSB_AMODE1     EQU 00100000b
  IOSB_AMODE2     EQU 01000000b
  IOSB_A70IN      EQU 00010000b
  IOSB_A70OUT     EQU 00000000b
  IOSB_C74IN      EQU 00001000b
  IOSB_C74OUT     EQU 00000000b
  IOSB_BMODE0     EQU 00000000b
  IOSB_BMODE1     EQU 00000100b
  IOSB_B70IN      EQU 00000010b
  IOSB_B70OUT     EQU 00000000b
  IOSB_C30IN      EQU 00000001b
  IOSB_C30OUT     EQU 00000000b

;  ⮢ ணࠬ㥬 䥩 (IO)

  IO_MODE_PORT    EQU IO_BASE+03h    ;  ணࠬ஢ IO
  IO_C_PORT       EQU IO_BASE+02h    ;  C
  IO_B_PORT       EQU IO_BASE+01h    ;  B
  IO_A_PORT       EQU IO_BASE+00h    ;  A

; ⠭  ࠡ  IO

  IO_MODE = IOSB_SETMODE+IOSB_AMODE0+IOSB_A70IN+IOSB_C74IN+IOSB_BMODE0
  IO_MODE = IO_MODE+IOSB_B70OUT+IOSB_C30OUT
  

; ------------------------------------------------------------------------
;   CT:
; ------------------------------------------------------------------------
;  ࠡ ⠩஢ -   ﭨ

  CTSB_TIMER0     EQU 00000000b      ; CT STATUS BITS
  CTSB_TIMER1     EQU 01000000b
  CTSB_TIMER2     EQU 10000000b
  CTSB_STOP       EQU 00000000b
  CTSB_LOWBYTE    EQU 00010000b
  CTSB_HIGHBYTE   EQU 00100000b
  CTSB_TWOBYTES   EQU 00110000b
  CTSB_MODE0      EQU 00000000b
  CTSB_MODE1      EQU 00000010b
  CTSB_MODE2      EQU 00000100b
  CTSB_MODE3      EQU 00000110b
  CTSB_MODE4      EQU 00001000b
  CTSB_MODE5      EQU 00001010b
  CTSB_BINCODE    EQU 00000000b
  CTSB_BINDECCODE EQU 00000001b

;  ⮢ ⠩ (CT)

  CT_MODE_PORT    EQU CT_BASE+03h    ;  ணࠬ஢ CT
  CT_TIMER2_PORT  EQU CT_BASE+02h    ;  2
  CT_TIMER1_PORT  EQU CT_BASE+01h    ;  1
  CT_TIMER0_PORT  EQU CT_BASE+00h    ;  0

; ⠭  ࠡ  ⠩ࠬ

  TIMER_MODE_PORT   EQU CT_MODE_PORT
  TIMER_STATE_PORT  EQU IO_C_PORT
  TIMER0_FREQUENCY  EQU 1000      ;  ᭮ ⠪஢  T0, 
  TIMER0_DELAY      EQU 2000000 / TIMER0_FREQUENCY

  TIMER0_MODE = CTSB_TIMER0+CTSB_TWOBYTES+CTSB_MODE2+CTSB_BINDECCODE
  TIMER1_MODE = CTSB_TIMER1+CTSB_TWOBYTES+CTSB_MODE0+CTSB_BINCODE
  TIMER2_MODE = CTSB_TIMER2+CTSB_TWOBYTES+CTSB_MODE0+CTSB_BINCODE  


; ------------------------------------------------------------------------
; 稥 ⠭
; ------------------------------------------------------------------------
; ⠭  ࠡ  ॢ⥫

  HEATER_MODE_PORT  EQU IO_C_PORT
  HEATER_STATE_PORT EQU IO_A_PORT
  HEATER_ON         EQU 1
  HEATER_OFF        EQU 0


; ========================================================================
; ------------------------------------------------------------------------
;  
; ------------------------------------------------------------------------
; . 室 ࠬ ணࠬ

ORG RAM_BASE             ;  ணࠬ 室  

    mvi  a,IO_MODE       ; 樠 ஫ -뢮
    out  IO_MODE_PORT

    xra  a               ; ⪠ 
    call Restart_Timer   ;  ⠩ 0

    ; ===   ⪥ 1 (dT=-50C, dt=5ᥪ)
    mvi  a,200                            ; 砫쭠 ⥬
    mvi  b,TIMER0_FREQUENCY * 5 SHR 4     ; ६ ॣ㫨஢ 5 ᥪ㭤
    mvi  c,TIMER0_FREQUENCY * 5 AND 0FFh
    mvi  d,TIMER0_FREQUENCY * 5 / 50 SHR 4    ; ६  T
    mvi  e,TIMER0_FREQUENCY * 5 / 50 AND 0FFh ;  1 ࠤ
    mvi  h,-1                             ;  ⥬
    call reg

    ; ===   ⪥ 2 (dT=0, dt=5ᥪ)
    mvi  a,150                         ; 砫쭠 ⥬
    mvi  b,TIMER0_FREQUENCY * 5 SHR 4  ; ६ ॣ㫨஢ 5 ᥪ㭤
    mvi  c,TIMER0_FREQUENCY * 5 AND 0FFh
    mvi  d,0FFh                        ; ६  ⥬
    mvi  e,0FFh                        ;  (T = const)
    mvi  h,0                           ; ⥬ ﭭ
    call reg

    ; ===   ⪥ 3 (dT=-100C, dt=2ᥪ)
    mvi  a,150                         ; 砫쭠 ⥬
    mvi  b,TIMER0_FREQUENCY * 2 SHR 4  ; ६ ॣ㫨஢ 2 ᥪ㭤
    mvi  c,TIMER0_FREQUENCY * 2 AND 0FFh
    mvi  d,TIMER0_FREQUENCY * 2 / 100 SHR 4    ; ६  ⥬
    mvi  e,TIMER0_FREQUENCY * 2 / 100 AND 0FFh ;  1 ࠤ
    mvi  h,-1                          ;  ⥬
    call reg

    ; === ⪫祭 ॢ⥫
    call Off_Heater

    ; === 襭 ணࠬ
    hlt

; ------------------------------------------------------------------------
; ணࠬ  ࠡ  ॢ⥫
; ------------------------------------------------------------------------
;
; On_Heater  Off_Heater:   몫 ॢ⥫ ᮮ⢥⢥
; : 
; : 
; :  
; :  

On_Heater:
    push b
    mov  b,a
    mvi  a,HEATER_MODE_PORT
    out  HEATER_ON
    mov  a,b
    pop  b
    ret

Off_Heater:
    push b
    mov  b,a
    mvi  a,HEATER_MODE_PORT
    out  HEATER_OFF
    mov  a,b
    pop  b
    ret

;
; Heater_Control: ணࠬ প  ⥬. ᫨
;   ⥬   ࠢ , 몫砥 ॢ⥫,
;    砥.
; : a -  ⥬
; : ᫨ ॢ⥫ 祭 CF=1,  CF=0
; :  
; : CF

Heater_Control:
    push b
    mov  b,a
    in   HEATER_STATE_PORT
    cmp  b
    jnc  Temperature_Is_Normal
    call On_Heater
    jmp  Exit_Heater_Control
  Temperature_Is_Normal:
    call Off_Heater   
  Exit_Heater_Control:
    mov  a,b
    pop  b
    ret


; ------------------------------------------------------------------------
; ணࠬ  ࠡ  ⠩ࠬ
; ------------------------------------------------------------------------
;
; Restart_Timer -  ⠩   N १.
; : a -  ⠩
;       b,c - ᫮ १    ⠩஢ 1  2
; : 
; :  
; :  

Restart_Timer:
    push psw
    jnz  IsTimer1
    mvi  a,TIMER0_MODE           ; 樠 ⠩ 0
    out  TIMER_MODE_PORT
    mvi  a,TIMER0_DELAY AND 0FFh ;    稭 প
    out  CT_TIMER0_PORT          
    mvi  a,TIMER0_DELAY SHR 4    ;  襣 
    out  CT_TIMER0_PORT
    jmp  Exit_Restart_Timer
  IsTimer1:
    dcr  a
    jnz  IsTimer2
    mvi  a,TIMER1_MODE
    out  TIMER_MODE_PORT
    mov  a,c
    out  CT_TIMER1_PORT
    mov  a,b
    out  CT_TIMER1_PORT
    jmp  Exit_Restart_Timer
  IsTimer2:
    dcr  a
    jnz  Exit_Restart_Timer
    mvi  a,TIMER2_MODE
    out  TIMER_MODE_PORT
    mov  a,c
    out  CT_TIMER2_PORT
    mov  a,b
    out  CT_TIMER2_PORT
  Exit_Restart_Timer:
    pop  psw
    ret    

; Check_Timers - ஢,  뫮  ࠡ뢠 ⠩
; : 
; : ᫨ ࠡ⠫ ⠩ 1, ⠭  1 ,
;        ᫨ ⠩ 2 -  2 (.. 1 - ⠩ 1, 2 - ⠩ 2)
;        ஬ ⮣, ᫨ ⠩ ࠡ⠫, ⠭ 䫠 CF
; : a
; : CF

Check_Timers:
    stc
    push b
    push psw
    in   TIMER_STATE_PORT
    ani  11000000b
    jnz  TimeOut
    pop  psw
    pop  b
    cmc
    ret
  TimeOut:
    rlc          ; Rotate bits to positions 0 and 1
    rlc  
    mov  b,a
    pop  psw
    mov  a,b
    pop  b
    ret


; ------------------------------------------------------------------------
; ணࠬ ॣ㫨஢ ⥬
; ------------------------------------------------------------------------
;
; Reg: ॣ㫨஢ ⥬
; : a   - 砫쭠 ⥬
;       b,c - ⠪⮢ ⠩ 0  砭 ॣ㫨஢
;       d,e - ⠪⮢ ⠩ 0   ⠢  T
;       h   - ࠢ  T -  +1, -1  0
; : 
; :  
; :  

Reg:
    push b              ; ࠭  ᭮ ॣ
    push d
    push h
    push psw

    push psw            ;  ⠩ 2   ६
    mvi  a,2            ;  ॣ b,c 㦥 ⠭, . 
    call Restart_Timer
    pop  psw

    push d              ; ஢  (d,e)   (b,c)
    pop  b
    mov  d,a            ; Store temperature in d

  T_Changed:
    mvi  a,1            ;   1...
    call Restart_Timer  ;  ...    ६   ⠢

  Reg_Next:
    mov  a,d            ; ⠭ ⠢ T
    call Heater_Control ; ॣ㫨㥬 ⥬
    call Check_Timers   ; ஢ਬ,  ࠡ⠫  ⠩
    jnc  Reg_Next
    cpi  1
    jnc  Exit_Reg       ; ᫨ ࠡ⠫ ⠩ 2 () -  室
    mov  a,d            
    add  h              ;   ⠢  ⥬,
    mov  d,a            ; ࠭ 
    jmp  T_Changed      ;  १⨬  ६ ⠢

  Exit_Reg:
    pop  psw            ; restore general registers
    pop  h
    pop  d
    pop  b
    ret
    
ENDALL
