unit UComRiad;

{$WARN SYMBOL_PLATFORM OFF}

interface

uses
Windows, ActiveX, Classes, ComObj, Chart, Grids, Math, SysUtils, IniFiles,
UCom_Tlb, ExtCtrls;

type
TRiad = class(TComObject, IComRiad)
protected
IniFile : TIniFile; // Ini-
w : integer;

public
Procedure Create(AIniFileName : string); stdcall;
Destructor Destroy;
procedure Graphic(AChart:TChart); stdcall; // 
procedure Table(AStringGrid:TStringGrid); stdcall; //  
procedure WriteToIniFile; stdcall; //  Ini-
procedure ReadFromIniFile; stdcall; //  Ini-
function GetW : integer; stdcall; // w
procedure SetW; stdcall; // w
function F(w:integer; t:extended):extended;stdcall;// 

private

end;

implementation

uses ComServ, Dialogs, Graphics, UnitMain;
const P=500;
const x=1;
const TimeStart=0; //  
const TimeEnd=100; //  
const TimeStep=0.5; //  

Procedure TRiad.Create(AIniFileName : string);
begin
//  Ini-
IniFile:= TIniFile.Create(AIniFileName);
end;//TRod.Create

Destructor TRiad.Destroy;
begin // 
//  Heap  Ini-
if Assigned(IniFile) then
begin
IniFile.Free;
IniFile:= NIL;
end;
end;//TRod.Create



procedure TRiad.Graphic(AChart : TChart);
// 
var
time : extended;
Y1, Y2 : extended;
begin
Time:= TimeStart;
AChart.Series[0].Clear; // Series[0]
AChart.Series[1].Clear; // Series[1]
AChart.BottomAxis.Increment:= Floor((TimeEnd - TimeStart) / 5);
//   Series
while(time <= TimeEnd) do
begin
Y1:= F(w,time);
Y2:= F(w,time);
AChart.Series[0].AddXY(time, Y1);
AChart.Series[1].AddXY(time, Y2);
time:= time + TimeStep / 4;
end;
end;//TRiad.Graphic

function TRiad.F(w : integer;t : extended) : extended;
// 
var
j:integer;
begin
 F:=(2*P/x)*(sin(w*t)-1/2*sin(2*w*t)+1/3*sin(3*w*t)-1/4*sin(4*w*t))
end;//TRiad.F

procedure TRiad.Table(AStringGrid : TStringGrid);
//   
var
k : integer;
time : extended;
y: extended;
begin
k:= 0;
time:= TimeStart;

while (time <= TimeEnd) do
begin
inc(k);
y:= F(w, time);
Form1.StringGrid1.Cells[2,k]:= FloatToStrF(y , ffFixed, 5, 3);
time:= time + TimeStep;
end;
end;//TRiad.Table

procedure TRiad.WriteToIniFile;
//  Ini-
begin
IniFile.WriteInteger('Parameters', 'W', W);
IniFile.UpdateFile;//      
end;//TRiad.WriteToIniFile

procedure TRiad.ReadFromIniFile;
//  Ini-
begin
W:= IniFile.ReadInteger('Parameters', 'W', w);
end;//TRiad.ReadFromIniFile

function TRiad.GetW :integer;
begin
 result:= W;
end;//TRiad.GetW

procedure TRiad.SetW;
begin
if Form1.RadioGroup1.ItemIndex=-1 then
    MessageDlg(Pchar('   w!!!'),mtError,[mbOk],0);
 if Form1.RadioGroup1.ItemIndex =0 then
  begin
  Form1.Label10.Caption:='1';
  w:=1;
  end
 else if Form1.RadioGroup1.ItemIndex =1 then
  begin
  Form1.label10.Caption:='3';
  w:=3;
   end
  else
  begin
  Form1.label10.Caption:='5';
  w:=5;
  end ;
 end;//TRiad.SetW


initialization
TComObjectFactory.Create(ComServer, TRiad, Class_ServerRiad,
'ServerRiad', '', ciMultiInstance, tmApartment);
end.


