unit URenameForm;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Buttons;

type
  TRenameFileForm = class(TForm)
    Label1: TLabel;
    OldFileName: TLabel;
    NewFileName: TEdit;
    BitBtn1: TBitBtn;
    BitBtn2: TBitBtn;
    procedure FormActivate(Sender: TObject);
    procedure BitBtn1Click(Sender: TObject);
    procedure BitBtn2Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  RenameFileForm: TRenameFileForm;

implementation
Uses UMainForm_, UMainForm, FmxUtils;
{$R *.DFM}

procedure TRenameFileForm.FormActivate(Sender: TObject);
begin
     NewFileName.Text:='';
     OldFileName.Caption:=MainForm.FileList.FileName;
     NewFileName.Text:=ExtractFileName(MainForm.FileList.FileName);
     RenameFileForm.ActiveControl:=NewFileName;
     NewFileName.SelectAll;
end;

procedure TRenameFileForm.BitBtn1Click(Sender: TObject);
begin
     If NewFileName.Text<>'' Then
        begin
             if MainForm.Directory.Directory[Length(MainForm.Directory.Directory)]<>'\' then
                begin
                     MoveFile(OldFileName.Caption,MainForm.Directory.Directory+'\'+NewFileName.Text);
                end
             else
                 begin
                      MoveFile(OldFileName.Caption,MainForm.Directory.Directory+NewFileName.Text);
                 end;
        RenameFileForm.Close;
        MainForm.FileList.Update;
        end;

end;

procedure TRenameFileForm.BitBtn2Click(Sender: TObject);
begin
     RenameFileForm.Close;
end;

end.
