unit UOptionsForm;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Buttons;

type
  TOptionsForm = class(TForm)
    GroupBox1: TGroupBox;
    AskOnExit: TCheckBox;
    BitBtn1: TBitBtn;
    BitBtn2: TBitBtn;
    Default: TCheckBox;
    CStatusBar: TCheckBox;
    Label1: TLabel;
    LFilelist: TLabel;
    procedure DefaultClick(Sender: TObject);
    procedure BitBtn1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure BitBtn2Click(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure LFilelistClick(Sender: TObject);
    procedure AskOnExitClick(Sender: TObject);
    procedure CStatusBarClick(Sender: TObject);
  private
    { Private declarations }
  public
   Procedure DefCheck;
    { Public declarations }
  end;

var
  OptionsForm: TOptionsForm;

implementation

Uses UMainForm_, UMainForm;
{$R *.DFM}
Procedure TOptionsForm.DefCheck;
          begin
              if (AskOnExit.Checked=True) and
                 (CStatusBar.Checked=True) and
                 (LFileList.Caption=FL1) then
              begin
                   Default.Checked:=True;
                   Default.Enabled:=False;
              end
              else
              begin
                   Default.Checked:=False;
                   Default.Enabled:=True;
              end;

          end;

procedure TOptionsForm.DefaultClick(Sender: TObject);
begin
     If Default.Checked then
         begin
              AskOnExit.Checked:=True;
              CStatusBar.Checked:=True;
              LFileList.Caption:=FL1;
         end;
     DefCheck;
end;

procedure TOptionsForm.BitBtn1Click(Sender: TObject);
begin
     UpdateMC;
     WriteIniOptions;
     OptionsForm.Close;
end;

procedure TOptionsForm.FormCreate(Sender: TObject);
begin
     ReadIniOptions;
     UpdateMC;
end;

procedure TOptionsForm.BitBtn2Click(Sender: TObject);
begin
     OptionsForm.Close;
end;

procedure TOptionsForm.FormActivate(Sender: TObject);
begin
    GetFormToCenter(OptionsForm);
         DefCheck;
end;

procedure TOptionsForm.LFilelistClick(Sender: TObject);
begin
     If LFileList.Caption=FL1 then
        LFileList.Caption:=FL2
     else
         if LFileList.Caption=FL2 then
            LFileList.Caption:=FL3
         else
             if LFileLIst.Caption=FL3 then
                LFileList.Caption:=FL1;
     DefCheck;
end;

procedure TOptionsForm.AskOnExitClick(Sender: TObject);
begin
     DefCheck;
end;

procedure TOptionsForm.CStatusBarClick(Sender: TObject);
begin
     DefCheck;
end;

end.
