unit UMainForm_; //  

interface
uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Menus,IniFiles,ExtCtrls, ComCtrls, StdCtrls, FileCtrl, Grids, Outline, DirOutln,
  ToolWin, Buttons;
Const
     FL1='1 column';
     FL2='2 column';
     FL3='3 column';
Var
   AskExit:boolean;
   MCIni:TIniFile;
   FlagCopyFile:Boolean;
   FlagMoveFile:Boolean;

Function FloatToInt(x:real):integer;
Procedure SaveIniMainForm;
Procedure ReadIniMainForm;
Procedure SetUpMainForm;
Procedure GetFormToCenter(Form:TForm);
Function FormatSize(S:String):String;
Procedure UpdateMC;
Procedure WriteIniOptions;
Procedure ReadIniOptions;
Procedure SetUpComponents;

Var
   ColDeleteFiles,ColFilesIn_TempCopyMove:integer;
   AllDeleteFlag,DeleteFlag:boolean;
   ResultFDCFFlag:integer;
   FDel:boolean;

Procedure CopyPathFileInTemp;
Function CreateStringForTemp(i:integer):string;
Procedure PasteFileFromTemp;
Function GetSizeAllFiles(List:TListBox):Integer;
Procedure DeleteEmptyDirectory(Dir:string);
Procedure CheckForOverwrite(Str:string;x:integer);

Var
   Ddir:string;
   DoingWithDir:boolean;
   DirSourse:string;

Procedure GreateCopyMoveDirList(DirS:string);
Procedure CopyMoveDirectory;

implementation

Uses UMainForm, UOptionsForm, FMXUtils, UAskDeleteForm, UAskDeleteCurrentFile,
     UDeleteDir;


Procedure CopyMoveDirectory;
//  
          begin
             MainForm.CMDirList.Clear;
             MainForm.CMFileList.Clear;
             MainForm.CMDirList.Items.Add(MainForm.Directory.Directory);
             //  
             GreateCopyMoveDirList(MainForm.Directory.Directory);
          end;

Procedure GreateCopyMoveDirList(DirS:string);
//     // 
          Var
             D:TSearchRec;
          begin
             FindFirst(DirS+'\'+'*.*',faAnyFile,D);
             FindNext(D);
             repeat
                   if (D.Name<>'.') and (D.Name<>'..') then
                      begin
                           if (D.Attr=faDirectory) Or (D.Attr=18) then
                              begin
                                   MainForm.CMDirList.Items.Add(DirS+'\'+D.Name);
                                   GreateCopyMoveDirList(DirS+'\'+D.Name);
                              end
                           else
                               begin
                                    MainForm.CMFileList.Items.Add(DirS+'\'+D.Name);
                               end;
                      end;
             Until(FindNext(D) <> 0);
            FindClose(D);
          end;

Procedure CheckForOverwrite(Str:string;x:integer);
//           
         Var
            i:integer;
            FilePaste:string;
            FileinDir:string;
            MStr:PChar;
         begin
              FilePaste:=ExtractFileName(Str);
              for i:=0 to ColAllFiles-1 do
                  begin
                       Str:=MainForm.FileList.Items[i];
                       FileInDir:=Str;
                       if FilePaste=FileInDir then
                          begin
                               Str:='OverWrite  '+MainForm.TempCopyMove.Items[x];
                               Mstr:=PChar(Str);
                               //   ,    
                               if Application.MessageBox(MStr,'Warning',1)<>1 then
                                  begin
                                       MainForm.TempCopyMove.Items[x]:=MainForm.TempCopyMove.Items[x]+'*';//.Delete(x);
                                       ColFilesIn_TempCopyMove:=ColFilesIn_TempCopyMove-2;
                                  end;
                          end;
                  end;
         end;

Procedure DeleteEmptyDirectory(Dir:String);
//  
          Var
             i:integer;
          begin
               {$I-}
               i:=MainForm.Directory.SelectedItem;
               MainForm.Directory.Directory:=(MainForm.Directory.Drive+':\');
               RmDir(Dir);
               if IOResult <> 0 then
                  begin
                       GetFormToCenter(FDeleteDir);
                       FDeleteDir.LDir.Caption:=Dir;
                       FDeleteDir.ShowModal;
                       if Fdel then
                           begin
                           MainForm.Directory.Delete(i);
                           RmDir(Dir);
                           end
                       Else
                           begin
                                MainForm.Directory.SetDirectory(Dir);
                                MainForm.Directory.BuildTree;
                           end;
                  end
                      Else MainForm.Directory.Delete(i);
               {$I+}
               MainForm.Directory.Update;
               MainForm.CMDirList.Items.Clear;
               MainForm.CMFileList.Items.Clear;
          end;

Function GetSizeAllFiles(List:TListBox):Integer;
//       
         Var
            i:integer;
            Size:integer;
         begin
              Size:=0;
              For i:=0 to List.Items.Count-1 do
                  begin
                       Size:=Size+GetFileSize(List.Items[i]);
                  end;
              GetSizeAllFiles:=Size;
         end;

Procedure PasteFileFromTemp;
// 
          Var
             StrPaste:string;
             Str:string;
             i:integer;
          begin
               //    
               If MainForm.Directory.Directory[Length(MainForm.Directory.Directory)]<>'\' then
                  begin
                       StrPaste:=MainForm.Directory.Directory+'\';
                  end
               else
                   begin
                        StrPaste:=MainForm.Directory.Directory;
                   end;
               //      
               For i:=0 to MainForm.TempCopyMove.Items.Count-1 do
                        CheckForOverwrite(MainForm.TempCopyMove.Items[i],i);
               For i:=0 to MainForm.TempCopyMove.Items.Count-1 do
                   begin
                        Str:=MainForm.TempCopyMove.Items[i];
                        //      
                        If FlagMoveFile then
                           begin
                                if Str[Length(str)]<>'*' then
                                   MoveFile(MainForm.TempCopyMove.Items[i],StrPaste);
                           end
                        else
                            begin
                                if Str[Length(str)]<>'*' then
                                   CopyFile(MainForm.TempCopyMove.Items[i],StrPaste);
                            end;
                       If Str[Length(str)]='*' then
                          begin
                               Str[Length(str)]:=#0;
                               MainForm.TempCopyMove.Items[i]:=Str;
                          end;
                   end;
               MainForm.FileList.Update;
               If FlagMoveFile then
                  begin
                       FlagMoveFile:=False;
                       MainForm.TempCopyMove.Clear;
                  end;
          end;

Function CreateStringForTemp(i:integer):string;
//    
          Var
             Str:string;
          begin
               Str:=MainForm.Directory.Directory;
               If Str[Length(Str)]<>'\' then
                  begin
                       Str:=Str+'\';
                  end;
               Str:=Str+MainForm.FileList.Items[i];
               CreateStringForTemp:=Str;
          end;

Procedure CopyPathFileInTemp;
//   
          Var
             i:integer;
          begin
               ColFilesIn_TempCopyMove:=0;
               MainForm.TempCopyMove.Clear;
               for i:=0 to ColAllFiles-1 do
                   begin
                        if MainForm.FileList.Selected[i] then
                           begin
                                ColFilesIn_TempCopyMove:=ColFilesIn_TempCopyMove+1;
                                If FlagMoveFile then
                                   begin
                                        MainForm.TempCopyMove.Items.Add(CreateStringForTemp(i));
                                        MainForm.FileList.Items[i]:='';
                                   end
                                else
                                    begin
                                         MainForm.TempCopyMove.Items.Add(CreateStringForTemp(i));
                                    end;
                           end;
                   end;
          end;

Procedure SetUpComponents;
          begin
               MainForm.StatusBar.Panels[0].Width:=MainForm.Directory.Width;
          end;

Procedure ReadIniOptions;
//    
          var tmpinteger:integer;
          begin
               with OptionsForm do
                    begin
                         AskOnExit.Checked:=MCIni.ReadBool('Options','AskOnExit',True);
                         CStatusBar.Checked:=MCIni.ReadBool('Options','StatusBar',True);
                         tmpinteger:=MCIni.ReadInteger('Options','FileListColumns',1);
                         Case tmpinteger of
                              1 : LFileList.Caption:=FL1;
                              2 : LFileList.Caption:=FL2;
                              3 : LFileList.Caption:=FL3;
                         end; //Case
                    end;
          end;

Procedure WriteIniOptions;
//     
          begin
               with MCIni do
                    begin
                         WriteBool('Options','AskOnExit',OptionsForm.AskOnExit.Checked);
                         WriteBool('Options','StatusBar',OptionsForm.CStatusBar.Checked);
                         Case MainForm.FileList.Columns of
                              1 : WriteInteger('Options','FileListColumns',1);
                              2 : WriteInteger('Options','FileListColumns',2);
                              3 : WriteInteger('Options','FileListColumns',3);
                         end; //case
                    end;
          end;

Procedure UpdateMC;
//    
          begin
               if OptionsForm.AskOnExit.Checked then AskExit:=True
               else AskExit:=False;
               If OptionsForm.CStatusBar.Checked then MainForm.StatusBar.Visible:=True
               else MainForm.StatusBar.Visible:=False;
               if OptionsForm.LFilelist.Caption=FL1 then
                  begin
                       MainForm.FileList.Columns:=1;
                       MainForm.FileList.Update;
                  end;
               if OptionsForm.LFilelist.Caption=FL2 then
                  begin
                       MainForm.FileList.Columns:=2;
                       MainForm.FileList.Update;
                  end;
               if OptionsForm.LFilelist.Caption=FL3 then
                  begin
                       MainForm.FileList.Columns:=3;
                       MainForm.FileList.Update;
                  end;
          end;

Procedure SetUpMainForm;
          begin
               //  
               MCIni:=TIniFile.Create('MC.Ini');
               ReadIniMainForm;
          end;

Procedure ReadIniMainForm;
          begin
               with MainForm do
                    begin
                         Top:=MCIni.ReadInteger('ASWindow','Top',100);
                         Left:=MCIni.ReadInteger('ASWindow','Left',100);
                         Height:=MCIni.ReadInteger('ASWindow','Height',100);
                         Width:=MCIni.ReadInteger('ASWindow','Width',100);
                         Directory.Width:=McIni.ReadInteger('ASWindow','Splitter',100);
                    end;
          end;

Procedure SaveIniMainForm;
          begin
               if MainForm.Top<>-4 then
               begin
               MCIni.WriteInteger('ASWindow','Top',MainForm.Top);
               MCIni.WriteInteger('ASWindow','Left',MainForm.Left);
               MCIni.WriteInteger('ASWindow','Width',MainForm.Width);
               MCIni.WriteInteger('ASWindow','Height',MainForm.Height);
               end;
          end;

Function FloatToInt(x:real):integer;
         begin
              FloatToInt:=StrToInt(FloatToStr(Int(X)));
         end;

Procedure GetFormToCenter(Form:TForm);
          begin
               Form.Top:=FloatToInt(MainForm.Top+MainForm.Height/2-Form.Height/2);
               Form.Left:=FloatToInt(MainForm.Left+MainForm.Width/2-Form.Width/2);
          end;

Function FormatSize(S:String):String;
//       (   / )
         Var
            i,j,n:integer;
            Tmp,Temp:String;
         begin
              Tmp:='';
              for i:=Length(S) downto 1 do
                       tmp:=tmp+S[i];
              n:=0;
              for i:=1 to Length(tmp) do
                  begin
                       if n=3 then
                          begin
                               n:=0;
                               Temp:=Temp+',';
                          end;
                       Temp:=Temp+Tmp[i];
                       n:=n+1;
                  end;
              Tmp:='';
              for i:=Length(Temp) downto 1 do
                  Tmp:=Tmp+Temp[i];
              FormatSize:=Tmp;
         end;
end.
