unit UMainForm; //   

interface
//   ()
uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Menus, ExtCtrls, ComCtrls, StdCtrls, FileCtrl, Grids, Outline, DirOutln,
  ToolWin, Buttons;

type
  TMainForm = class(TForm)
    MainMenu1: TMainMenu;
    File1: TMenuItem;
    About1: TMenuItem;
    N1: TMenuItem;
    Exit1: TMenuItem;
    Options1: TMenuItem;
    Directory: TDirectoryOutline;
    FileList: TFileListBox;
    Drv: TDriveComboBox;
    StatusBar: TStatusBar;
    DirectoryMenu: TPopupMenu;
    FileMenu: TPopupMenu;
    Splitter: TSplitter;
    Cut: TMenuItem;
    Copy: TMenuItem;
    Paste: TMenuItem;
    Rename1: TMenuItem;
    Delete: TMenuItem;
    NewDir: TMenuItem;
    CopyDir: TMenuItem;
    RenameDir: TMenuItem;
    DeleteDir: TMenuItem;
    PasteDir: TMenuItem;
    TempDelete: TListBox;
    TempCopyMove: TListBox;
    Open: TMenuItem;
    View: TMenuItem;
    FileMask1: TMenuItem;
    CMDirList: TListBox;
    DFileList: TListBox;
    Find1: TMenuItem;
    Info1: TMenuItem;
    CMFileList: TListBox;
    FileAttr: TMenuItem;
    SizeDirectory1: TMenuItem;
    CutDir: TMenuItem;
    ToolBar1: TToolBar;
    DrBox: TDriveComboBox;
    Bevel1: TBevel;
    Bevel2: TBevel;
    SpeedButton1: TSpeedButton;
    SCut: TSpeedButton;
    Bevel3: TBevel;
    SCopy: TSpeedButton;
    SPaste: TSpeedButton;
    SDel: TSpeedButton;
    Up: TSpeedButton;
    Bevel4: TBevel;
    Cut1: TMenuItem;
    Copy1: TMenuItem;
    Paste1: TMenuItem;
    Rename: TMenuItem;
    Delete1: TMenuItem;
    Selectall: TMenuItem;
    InvertSelect: TMenuItem;
    procedure About1Click(Sender: TObject);
    procedure Exit1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure Options1Click(Sender: TObject);
    procedure DrivesSectionClick(HeaderControl: THeaderControl;
      Section: THeaderSection);
    procedure DrivesMouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure NewDirClick(Sender: TObject);
    procedure DirectoryChange(Sender: TObject);
    procedure CopyClick(Sender: TObject);
    procedure CutClick(Sender: TObject);
    procedure PasteClick(Sender: TObject);
    procedure Rename1Click(Sender: TObject);
    procedure DeleteDirClick(Sender: TObject);
    procedure DeleteClick(Sender: TObject);
    procedure FileMenuPopup(Sender: TObject);
    procedure FileMask1Click(Sender: TObject);
    procedure FileListDblClick(Sender: TObject);
    procedure SplitterMoved(Sender: TObject);
    procedure Find1Click(Sender: TObject);
    procedure Info1Click(Sender: TObject);
    procedure CopyDirClick(Sender: TObject);
    procedure RenameDirClick(Sender: TObject);
    procedure FileAttrClick(Sender: TObject);
    procedure ViewClick(Sender: TObject);
    procedure SizeDirectory1Click(Sender: TObject);
    procedure FileListMouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure FileListKeyPress(Sender: TObject; var Key: Char);
    procedure FileListKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure PasteDirClick(Sender: TObject);
    procedure DirectoryMenuPopup(Sender: TObject);
    procedure File1Click(Sender: TObject);
    procedure OpenClick(Sender: TObject);
    procedure DrBoxChange(Sender: TObject);
    procedure UpClick(Sender: TObject);
    procedure SCutClick(Sender: TObject);
    procedure SPasteClick(Sender: TObject);
    procedure SDelClick(Sender: TObject);
    procedure SCopyClick(Sender: TObject);
    procedure FileListClick(Sender: TObject);
    procedure CutDirClick(Sender: TObject);
    procedure Cut1Click(Sender: TObject);
    procedure Copy1Click(Sender: TObject);
    procedure Paste1Click(Sender: TObject);
    procedure Delete1Click(Sender: TObject);
    procedure RenameClick(Sender: TObject);
    procedure FormResize(Sender: TObject);
    procedure InvertSelectClick(Sender: TObject);
    procedure FileListKeyUp(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure SelectallClick(Sender: TObject);
  private
  public
  end;

var
  MainForm: TMainForm;
  Size:integer;

implementation

//   ( )
uses UAboutBox,UMainForm_, UOptionsForm, UCreateDir, UProgressForm,
  URenameForm, UAskDeleteForm, UGetFileMask, FmxUtils, UFindForm, UInfoForm,
  UAttrFilesForm,UNotTrivial, UDeleteDir, URenameDirForm, URunForm,
  UViewForm;

{$R *.DFM}

procedure TMainForm.About1Click(Sender: TObject);
//   "  "
begin
     AboutBox.Show;
end;

procedure TMainForm.Exit1Click(Sender: TObject);
//    
begin
     If AskExit then
        begin
             //  
             If Application.MessageBox('Exit ?','Exit',MB_APPLMODAL+MB_ICONQuestion+MB_YESNO)=IDYes then
                Begin
                     //       .INI
                     SaveIniMainForm;
                     Close;
                end
        end
     else
         begin
              SaveIniMainForm;
              Close;
         end;
end;

procedure TMainForm.FormCreate(Sender: TObject);
//      
begin
     SetUpMainForm;
     SetUpComponents;
end;

procedure TMainForm.Options1Click(Sender: TObject);
//  
begin
     //      
     GetFormToCenter(OptionsForm);
     OptionsForm.ShowModal;
end;

procedure TMainForm.DrivesSectionClick(HeaderControl: THeaderControl;
  Section: THeaderSection);
//   
begin
     Directory.Drive:=Section.Text[1];
     Directory.SetDirectory(Section.Text[1]+':\');
     MainForm.Directory.BuildTree;
end;

procedure TMainForm.DrivesMouseUp(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
     //    
    Directory.Repaint;
end;

procedure TMainForm.NewDirClick(Sender: TObject);
//      
begin
     CreateDirForm.Show;
end;

Function CountDir(Str:String):String;
//      
         Var F:TSearchRec;
             C:integer;
         begin
              c:=0;
              findfirst(Str+'\*.*',faAnyFile,F);
              findnext(F);
              repeat
                    if (f.Attr>=16) and (f.attr<32) and (f.Name<>'.') and (f.Name<>'..') then
                    c:=c+1;
              Until(findnext(f)<>0);
              CountDir:=IntToStr(c);
         end;


procedure TMainForm.DirectoryChange(Sender: TObject);
//  
begin
//  
     FileList.SetDirectory(Directory.Directory);
// -
     MainForm.StatusBar.Panels[0].Text:=CountDir(Directory.Directory)+' dir. & '+IntToStr(MainForm.FileList.Items.Count)+
               ' files ';
     MainForm.StatusBar.Panels[1].Text:='';
//    
     If UpperCase(MainForm.Directory.Directory)=UpperCase(MainForm.DrBox.Drive+':\') then
        begin
             Up.Enabled:=False;
             SCut.Enabled:=False;
             SCopy.Enabled:=False;
             SDel.Enabled:=False;
        end
     else
         begin
              Up.Enabled:=True;
             SCut.Enabled:=True;
             SCopy.Enabled:=True;
             SDel.Enabled:=True;
         end;
end;

procedure TMainForm.CopyClick(Sender: TObject);
//  
begin
     FlagCopyFile:=True;
     FlagMoveFile:=False;
     CopyPathFileInTemp;
end;

procedure TMainForm.CutClick(Sender: TObject);
//  
begin
     FlagMoveFile:=True;
     CopyPathFileInTemp;
end;

procedure TMainForm.PasteClick(Sender: TObject);
begin
     ProgressForm.Show;
     PasteFileFromTemp;
     ProgressForm.Close;
     MainForm.TempCopyMove.Clear;
end;

procedure TMainForm.Rename1Click(Sender: TObject);
//      
begin
     GetFormToCenter(RenameFileForm);
     RenameFileForm.ShowModal;
end;

procedure TMainForm.DeleteDirClick(Sender: TObject);
//  
begin
     //   
     MainForm.CMDirList.Clear;
     MainForm.CMFileList.Clear;
     DeleteEmptyDirectory(MainForm.Directory.Directory);
     //  
     MainForm.Directory.Invalidate;
end;

procedure TMainForm.DeleteClick(Sender: TObject);
// 
begin
     AskDeleteForm.Show;
end;

procedure TMainForm.FileMenuPopup(Sender: TObject);
//       
//   
begin
     if MainForm.FileList.SelCount=0 then
        begin
             with MainForm.FileMenu do
                  begin
                       Delete.Enabled:=False;
                       Cut.Enabled:=False;
                       Copy.Enabled:=False;
                       Rename1.Enabled:=False;
                  end;
        end
     else
         begin
              with MainForm.FileMenu do
                   begin
                        Delete.Enabled:=True;
                        Cut.Enabled:=True;
                        Copy.Enabled:=True;
                        Rename1.Enabled:=True;
                   end;
         end;
     if MainForm.TempCopyMove.Items.Count = 0 then
        Paste.Enabled:=False
     else
        Paste.Enabled:=True;
end;

procedure TMainForm.FileMask1Click(Sender: TObject);
//       (  )
begin
     GetFileMask.Show;
end;

procedure TMainForm.FileListDblClick(Sender: TObject);
//  /()   
//    
Var
   str:string;
begin
     Str:=FileList.FileName;
     ExecuteFile(Str,'','',SW_SHOW);
end;

procedure TMainForm.SplitterMoved(Sender: TObject);
//      (  )
begin
     //    
     //         (  )
     if Splitter.Left<=DrBox.Width then
        begin
             Directory.Width:=DrBox.Width+6;
        end;
     //       
     McIni.WriteInteger('ASWindow','Splitter',MainForm.Directory.Width);
     //    -
     MainForm.StatusBar.Panels[0].Width:=MainForm.Directory.Width;
end;

procedure TMainForm.Find1Click(Sender: TObject);
//  
begin
     FindForm.Show
end;

procedure TMainForm.Info1Click(Sender: TObject);
//       
begin
     GetFormToCenter(InfoForm);
     InfoForm.ShowModal;
end;

procedure TMainForm.CopyDirClick(Sender: TObject);
//  (   )
begin
     SourseDir:=MainForm.Directory.Directory;
     DoingWithDir:=True;
     CopyMoveDirectory;
end;

procedure TMainForm.RenameDirClick(Sender: TObject);
//    
begin
     GetFormToCenter(RenameDirForm);
     RenameDirForm.ShowModal;
end;

procedure TMainForm.FileAttrClick(Sender: TObject);
//     . 
begin
     GetFormToCenter(AttrFileForm);
     AttrFileForm.ShowModal;
end;

procedure TMainForm.ViewClick(Sender: TObject);
//      VIEW
//    
begin
     if MainForm.FileList.SelCount = 0 then
        begin
             MainForm.FileAttr.Enabled:=False;
        end
     else
         begin
              MainForm.FileAttr.Enabled:=True;
         end;
     if UpperCase(MainForm.Directory.Directory)=UpperCase(MainForm.DrBox.Drive+':\') then
        MainForm.SizeDirectory1.Enabled:=False
     else
         MainForm.SizeDirectory1.Enabled:=True;
end;

Procedure DDD(DirS:string);
//    
          Var
             d:TSearchRec;
          begin
             FindFirst(DirS+'\'+'*.*',faAnyFile,D);
             FindNext(D);
             repeat
                   if (D.Name<>'.') and (D.Name<>'..') then
                      begin
                           if (D.Attr=faDirectory) Or (D.Attr=18) then
                              begin
                                   DDD(DirS+'\'+D.Name);
                              end
                           else
                               begin
                                    Size:=Size+D.Size;
                               end;
                      end;
             Until(FindNext(D) <> 0);
             FindClose(D);
          end;


procedure TMainForm.SizeDirectory1Click(Sender: TObject);
//       -
begin
     Size:=0;
     MainForm.StatusBar.Panels[0].Text:='Wait...';
     DDD(MainForm.Directory.Directory);
     MainForm.StatusBar.Panels[0].Text:=FormatSize(IntToStr(Size)); //     
     MainForm.StatusBar.Panels[0].Text:=MainForm.StatusBar.Panels[0].Text+' b';
end;

procedure TMainForm.FileListMouseUp(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
//    
Var
   i:integer;
   F:TSearchRec;
   str:string;
begin
             str:='                                                                                                              ';
                Size:=0;
             //          
             for i:=0 to MainForm.FileList.Items.Count-1 do
                 begin
                      if MainForm.FileList.Selected[i] then
                         begin
                              FindFirst(MainForm.FileList.Items[i],faAnyFile,F);
                              Size:=Size+F.Size;
                              if MainForm.FileList.SelCount=1 then break;
                         end;
                 end;
             //    ,       
             if MainForm.FileList.SelCount=1 then
                begin
                     MainForm.StatusBar.Panels[1].Text:=ExtractFileName(F.Name)+'    '+
                              FormatSize(IntToStr(F.Size))+' b'+'    '+
                              DateToStr(FileDateTime(F.Name))+'    '+TimeToStr(FileDateTime(F.Name));
                end
             else
                 begin
                     MainForm.StatusBar.Panels[1].Text:=FormatSize(intToStr(Size))+' b'+
                             ' in '+IntToStr(MainForm.FileList.SelCount)+ ' selected files';
                 end;
end;
Procedure ReselectAllFile;
//   
          Var i:integer;
          begin
               For i:=0 to MainForm.FileList.Items.Count-1 do
                   MainForm.FileList.Selected[i]:=not MainForm.FileList.Selected[i];
          end;

Procedure SelectAllF(Key:Char);
//     
Var
   i:integer;
   F:TsearchRec;
   Str:string;
begin
     if Key='*' then
        begin
             if MainForm.FileList.SelCount=MainForm.FileList.Items.Count then
                ReselectAllFile
             else
             begin
             for i:=0 to MainForm.FileList.Items.Count-1 do
                 MainForm.FileList.Selected[i]:=True;
             str:='                                                                                                              ';
                Size:=0;
//  -
             for i:=0 to MainForm.FileList.Items.Count-1 do
                 begin
                      if MainForm.FileList.Selected[i] then
                         begin
                              FindFirst(MainForm.FileList.Items[i],faAnyFile,F);
                              Size:=Size+F.Size;
                              if MainForm.FileList.SelCount=1 then break;
                         end;
                 end;
             if MainForm.FileList.SelCount=1 then
                begin
                     MainForm.StatusBar.Panels[1].Text:=ExtractFileName(F.Name)+'    '+
                              FormatSize(IntToStr(F.Size))+' b'+'    '+
                              DateToStr(FileDateTime(F.Name))+'    '+TimeToStr(FileDateTime(F.Name));
                end
             else
                 begin
                     MainForm.StatusBar.Panels[1].Text:=FormatSize(intToStr(Size))+' b'+
                             ' in '+IntToStr(MainForm.FileList.SelCount)+ ' selected files';
                 end;
             end;
        end;
end;


procedure TMainForm.FileListKeyPress(Sender: TObject; var Key: Char);
begin
     SelectAllF(Key);
end;

procedure TMainForm.FileListKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
//   
Var
   i:integer;
   F:TSearchRec;
   str:string;
begin
              //   ENTER  
             if (Key=13) and not AskDeleteForm.Active then ExecuteFile(FileList.FileName,'','',SW_SHOW);
             str:='                                                                                                              ';
             Size:=0;
             for i:=0 to MainForm.FileList.Items.Count-1 do
                 begin
                      if MainForm.FileList.Selected[i] then
                         begin
                              FindFirst(MainForm.FileList.Items[i],faAnyFile,F);
                              Size:=Size+F.Size;
                              if MainForm.FileList.SelCount=1 then break;
                         end;
                 end;
//               
             if MainForm.FileList.SelCount=1 then
                begin
                     MainForm.StatusBar.Panels[1].Text:=ExtractFileName(F.Name)+'    '+
                              FormatSize(IntToStr(F.Size))+' b'+'    '+
                              DateToStr(FileDateTime(F.Name))+'    '+TimeToStr(FileDateTime(F.Name));
                end
             else
                 begin
                     MainForm.StatusBar.Panels[1].Text:=FormatSize(intToStr(Size))+' b'+
                             ' in '+IntToStr(MainForm.FileList.SelCount)+ ' selected files';
                 end;
end;

procedure TMainForm.PasteDirClick(Sender: TObject);
// 
begin
     DestinationDir:=MainForm.Directory.Directory;
     PasteDirectory(SourseDir,MainForm.Directory.Directory);
     MainForm.Directory.BuildTree;
     //     
     If not DoingWithDir then
        begin
             DelNotEmptyDirectory(SourseDir);
             MainForm.Directory.BuildTree;
        end;
     MainForm.CMDirList.Clear;
end;

procedure TMainForm.DirectoryMenuPopup(Sender: TObject);
//      
begin
     if MainForm.CMDirList.Items.Count=0 then
        PasteDir.Enabled:=False
     else
         PasteDir.Enabled:=True;
     If Length(MainForm.Directory.Directory) <= 3 then
        begin
             CopyDir.Enabled:=False;
             CutDir.Enabled:=False;
             DeleteDir.Enabled:=False;
             RenameDir.Enabled:=False;
        end
     else
         begin
              CutDir.Enabled:=True;
              CopyDir.Enabled:=True;
              DeleteDir.Enabled:=True;
              RenameDir.Enabled:=True;
         end;
end;

procedure TMainForm.File1Click(Sender: TObject);
//        / 
//  RUN     FILE
begin
     if (UpperCase(ExtractFileExt(MainForm.FileList.FileName))='.EXE') or
        (UpperCase(ExtractFileExt(MainForm.FileList.FileName))='.COM') then
             Open.Enabled:=True
        else Open.Enabled:=False;
end;

procedure TMainForm.OpenClick(Sender: TObject);
//    
begin
     GetFormToCenter(RunForm);
     RunForm.ShowModal;
end;

procedure TMainForm.DrBoxChange(Sender: TObject);
//       
Var F:TSearchRec;
    s:string;
begin
     MainForm.Directory.Drive:=MainForm.DrBox.Drive;
     MainForm.FileList.Directory:=MainForm.DrBox.Drive+':\';
     S:=MainForm.FileList.Mask;
     MainForm.FileList.Mask:='>.>';
     FindFirst(MainForm.DrBox.Drive+':\*.*',faDirectory,F);
     Repeat
     Until ((FindNext(F)<>0) or ((F.Attr=faDirectory) and ((F.Name<>'.') or (F.Name<>'..'))));
     if F.Attr<>faDirectory then
        MainForm.Directory.SetDirectory(MainForm.DrBox.Drive+':\')
     else
         MainForm.Directory.SetDirectory(MainForm.DrBox.Drive+':\'+F.Name);
         MainForm.Directory.BuildTree;
         MainForm.Directory.SetDirectory(MainForm.DrBox.Drive+':\');
         MainForm.FileList.Enabled:=True;
         MainForm.FileList.Mask:=s;
         MainForm.StatusBar.Panels[0].Text:=IntToStr(MainForm.FileList.Items.Count)+
               ' files ';
end;

procedure TMainForm.UpClick(Sender: TObject);
//       
Var
   i:integer;
   Str:string;
begin
     str:=MainForm.Directory.Directory;
     for i:=Length(Str) downto 0 do
         if Str[i]='\' then
            begin
                 str[i+1]:=#0;
                 break;
            end;
     MainForm.Directory.Directory:=str;
     MainForm.Directory.BuildTree;
end;

procedure TMainForm.SCutClick(Sender: TObject);
//      
begin
     //     
     if MainForm.FileList.Focused then
        begin
             FlagMoveFile:=True;
             CopyPathFileInTemp;
        end;
     //     
     If MainForm.Directory.Focused then
        begin
             SourseDir:=MainForm.Directory.Directory;
             DoingWithDir:=False;
             MainForm.CMDirList.Items.Add(MainForm.Directory.Directory);
             GreateCopyMoveDirList(MainForm.Directory.Directory);
        end;
end;

procedure TMainForm.SPasteClick(Sender: TObject);
//     
begin
     //  (   )   
     //   
     if MainForm.TempCopyMove.Items.Count<>0 then
        begin
             ProgressForm.Show;
             PasteFileFromTemp;
             ProgressForm.Close;
        end;
     If MainForm.CMDIrList.Items.Count<>0 then
        begin
             DestinationDir:=MainForm.Directory.Directory;
             PasteDirectory(SourseDir,MainForm.Directory.Directory);
             MainForm.Directory.BuildTree;
             If not DoingWithDir then
                begin
                     DelNotEmptyDirectory(SourseDir);
                     MainForm.Directory.BuildTree;
                end;
             MainForm.CMDirList.Clear;
        end;
end;

procedure TMainForm.SDelClick(Sender: TObject);
//    
begin
     if (MainForm.FileList.Focused) and (MainForm.FileList.SelCount>0) then
        begin
             AskDeleteForm.ShowModal;
        end;
     if MainForm.Directory.Focused then
        begin
             IndexDeleteDirectory:=MainForm.Directory.SelectedItem;
             MainForm.CMDirList.Clear;
             MainForm.CMFileList.Clear;
             DeleteEmptyDirectory(MainForm.Directory.Directory);
             MainForm.Directory.Invalidate;
        end;
end;

procedure TMainForm.SCopyClick(Sender: TObject);
//    
begin
     If MainForm.Directory.Focused then
        begin
             SourseDir:=MainForm.Directory.Directory;
             DoingWithDir:=True;
             CopyMoveDirectory;
        end;
     If MainForm.FileList.Focused then
        begin
             FlagCopyFile:=True;
             FlagMoveFile:=False;
             CopyPathFileInTemp;
        end;
end;

procedure TMainForm.FileListClick(Sender: TObject);
begin
     MainForm.SDel.Enabled:=True;
     MainForm.SCopy.Enabled:=True;
     MainForm.SCut.Enabled:=True;
end;

procedure TMainForm.CutDirClick(Sender: TObject);
//  
begin
             SourseDir:=MainForm.Directory.Directory;
             DoingWithDir:=False;
             MainForm.CMDirList.Items.Add(MainForm.Directory.Directory);
             GreateCopyMoveDirList(MainForm.Directory.Directory);
end;

procedure TMainForm.Cut1Click(Sender: TObject);
//     
begin
     if MainForm.FileList.Focused then
        begin
             FlagMoveFile:=True;
             CopyPathFileInTemp;
        end;
     If MainForm.Directory.Focused then
        begin
             SourseDir:=MainForm.Directory.Directory;
             DoingWithDir:=False;
             MainForm.CMDirList.Items.Add(MainForm.Directory.Directory);
             GreateCopyMoveDirList(MainForm.Directory.Directory);
        end;
end;

procedure TMainForm.Copy1Click(Sender: TObject);
//     
begin
     If MainForm.Directory.Focused then
        begin
             SourseDir:=MainForm.Directory.Directory;
             DoingWithDir:=True;
             CopyMoveDirectory;
        end;
     If MainForm.FileList.Focused then
        begin
             FlagCopyFile:=True;
             FlagMoveFile:=False;
             CopyPathFileInTemp;
        end;
end;

procedure TMainForm.Paste1Click(Sender: TObject);
//     
begin
     if MainForm.TempCopyMove.Items.Count<>0 then
        begin
             ProgressForm.Show;
             PasteFileFromTemp;
             ProgressForm.Close;
        end;
     If MainForm.CMDIrList.Items.Count<>0 then
        begin
     DestinationDir:=MainForm.Directory.Directory;
     PasteDirectory(SourseDir,MainForm.Directory.Directory);
     MainForm.Directory.BuildTree;
     If not DoingWithDir then
        begin
             DelNotEmptyDirectory(SourseDir);
             MainForm.Directory.BuildTree;
        end;
     MainForm.CMDirList.Clear;
        end;
end;

procedure TMainForm.Delete1Click(Sender: TObject);
//    
begin
     if (MainForm.FileList.Focused) and (MainForm.FileList.SelCount>0) then
        begin
             AskDeleteForm.Show;
        end;
     if MainForm.Directory.Focused then
        begin
             IndexDeleteDirectory:=MainForm.Directory.SelectedItem;
             MainForm.CMDirList.Clear;
             MainForm.CMFileList.Clear;
             DeleteEmptyDirectory(MainForm.Directory.Directory);
             MainForm.Directory.Invalidate;
        end;
end;

procedure TMainForm.RenameClick(Sender: TObject);
//     
begin
     If MainForm.Directory.Focused then
        begin
             GetFormToCenter(RenameDirForm);
             RenameDirForm.ShowModal;
        end;
     if MainForm.FileList.Focused then
        begin
             RenameFileForm.ShowModal;
        end;
end;

procedure TMainForm.FormResize(Sender: TObject);
//       
begin
     if MainForm.Width<391 then
        MainForm.Width:=391;
     if MainForm.Height<260 then
        MainForm.Height:=260;
end;

procedure TMainForm.InvertSelectClick(Sender: TObject);
begin
     ReselectAllFile;
end;

procedure TMainForm.FileListKeyUp(Sender: TObject; var Key: Word;
  Shift: TShiftState);
//      
Var
   i:integer;
   F:TSearchRec;
   str:string;
begin
              //  -
             str:='                                                                                                              ';
             Size:=0;
             for i:=0 to MainForm.FileList.Items.Count-1 do
                 begin
                      if MainForm.FileList.Selected[i] then
                         begin
                              FindFirst(MainForm.FileList.Items[i],faAnyFile,F);
                              Size:=Size+F.Size;
                              if MainForm.FileList.SelCount=1 then break;
                         end;
                 end;
             if MainForm.FileList.SelCount=1 then
                begin
                     MainForm.StatusBar.Panels[1].Text:=ExtractFileName(F.Name)+'    '+
                              FormatSize(IntToStr(F.Size))+' b'+'    '+
                              DateToStr(FileDateTime(F.Name))+'    '+TimeToStr(FileDateTime(F.Name));
                end
             else
                 begin
                     MainForm.StatusBar.Panels[1].Text:=FormatSize(intToStr(Size))+' b'+
                             ' in '+IntToStr(MainForm.FileList.SelCount)+ ' selected files';
                 end;
end;

procedure TMainForm.SelectallClick(Sender: TObject);
begin
SelectAllF('*');
end;
end.
