unit UInfoForm;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Buttons;

type
  TInfoForm = class(TForm)
    BitBtn1: TBitBtn;
    LDiskSize: TLabel;
    Label1: TLabel;
    LCurrentDir: TLabel;
    LFilesAndSize: TLabel;
    LFreeSpaseDisk: TLabel;
    procedure BitBtn1Click(Sender: TObject);
    procedure FormActivate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  InfoForm: TInfoForm;

implementation

Uses
    UMainForm,UMainForm_,FmxUtils;
{$R *.DFM}

procedure TInfoForm.BitBtn1Click(Sender: TObject);
begin
     InfoForm.Close;
end;

procedure TInfoForm.FormActivate(Sender: TObject);
Var
   i:integer;
   Size:integer;
begin
     LCurrentDir.Caption:=MainForm.Directory.Directory+';';
     LFilesAndSize.Caption:=IntToStr(MainForm.FileList.Items.Count)+' files with ';
     Size:=0;
     for i:=0 to MainForm.FileList.Items.Count-1 do
         begin
              Size:=Size+GetFileSize(MainForm.FileList.Items[i]);
         end;
     LFilesAndSize.Caption:=LFilesAndSize.Caption+FormatSize(IntToStr(Size))+ ' bytes';
     LDiskSize.Caption:=FormatSize(IntToStr(DiskSize(0)));
     LDiskSize.Caption:=LDiskSize.Caption+' total bytes on drive '+MainForm.Directory.Drive+':';
     LFreeSpaseDisk.Caption:=FormatSize(IntToStr(DiskFree(0)));
     LFreeSpaseDisk.Caption:=LFreeSpaseDisk.Caption+' free bytes on drive '+MainForm.Directory.Drive+':';;
end;

end.
