unit UDelDir; {      }

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Buttons, ExtCtrls, ToolWin, ComCtrls, checklst;

type
  TDelDir = class(TForm)
    DirBox: TCheckListBox;
    ToolBar1: TToolBar;
    ToolBar2: TToolBar;
    S1: TSpeedButton;
    S2: TSpeedButton;
    SB: TStatusBar;
    Label1: TLabel;
    procedure S2Click(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure DirBoxClickCheck(Sender: TObject);
    procedure S1Click(Sender: TObject);
    procedure FormResize(Sender: TObject);
    procedure DirBoxKeyPress(Sender: TObject; var Key: Char);
    procedure DirBoxClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  DelDir: TDelDir;

implementation
Uses UMF;
{$R *.DFM}

procedure TDelDir.S2Click(Sender: TObject);
Var i:integer;
{   }
begin
     DirBox.Clear;
     DelDir.Close;
end;

Function CheckStrOnDirBox(S:string):boolean;
         Var i:integer;
             Flag:boolean;
         begin
              Flag:=True;
              for i:=0 to DElDir.DirBox.Items.Count-1 do
                  begin
                       if S=DelDir.DirBox.Items[i] then
                          begin
                               Flag:=False;
                               Break;
                          end
                       Else Flag:=True;
                  end;
              CheckStrOnDirBox:=Flag;
         end;

Procedure AddString(Str:string);
          Var i:integer;
          begin
               Str:=ExtractFileDir(Str);
               if CheckStrOnDirBox(Str) then
                  DelDir.DirBox.Items.Add(Str);
          end;


Procedure CreateListAllDir;
{  }
          Var i:integer;
          begin
               For i:=0 to MF.List.Items.Count-1 do
                   begin
                        AddString(MF.List.Items[i]);
                   end;

          end;

Procedure CountDir;
{       }
          Var i:integer;
              C:integer;
              Str:string;
          begin
               C:=0;
               Str:='  '+IntToStr(DelDir.DirBox.Items.Count)+'  Directory ';
               For i:=0 to DelDir.DirBox.Items.Count-1 do
                   begin
                        if DelDir.DirBox.Checked[i] then c:=c+1;
                   end;
               Str:=Str+'    and '+IntToStr(c)+'  To Delete';
               DelDir.SB.Panels[0].Text:=Str;
          end;

Function CountSlash(Str:String):integer;
         Var i,c:integer;
         begin
              for i:=0 to Length(Str) do
                  if Str[i]='\' then c:=c+1;
              CountSlash:=c;
         end;

Function CheckSort:boolean;
         Var i:integer;Flag:boolean;
         begin
              Flag:=True;
              For i:=0 to DelDir.DirBox.Items.Count-2 do
                  begin
                       if CountSlash(DelDir.DirBox.Items[i])>CountSlash(DelDir.DirBox.Items[i+1]) then
                          begin
                               Flag:=False;
                               Break;
                          end
                       else
                           Flag:=True;
                  end;
              CheckSort:=Flag;
         end;

Procedure SortListAllDir;
{  }
          Var
             i:integer;
             N:String;
          begin
               repeat
               for i:=0 to DelDir.DirBox.Items.Count-2 do
                   begin
                        if CountSlash(DelDir.DirBox.Items[i])>CountSlash(DelDir.DirBox.Items[i+1]) then
                           begin
                                N:=DelDir.DirBox.Items[i];
                                DelDir.DirBox.Items[i]:=DelDir.DirBox.Items[i+1];
                                DelDir.DirBox.Items[i+1]:=N;
                           end;
                   end;
               Until (CheckSort);
          end;

procedure TDelDir.FormActivate(Sender: TObject);
{        }
begin
     CreateListAllDir;
     SortListAllDir;
     CountDir;
     S1.Enabled:=False;
     S1.Width:=FloatToInt(DelDir.Width/2);
     S2.Width:=FloatToInt(DelDir.Width/2);
end;

procedure TDelDir.DirBoxClickCheck(Sender: TObject);
begin
     CountDir;
end;

Function CStr(A,B:string):boolean;
         Var
            i:integer;
            Flag:Boolean;
         begin
              Flag:=True;
              if Length(A)>Length(B) then
              for i:=0 to Length(B) do
                  if A[i]<>B[i] then
                     begin
                          Flag:=False;
                          Break;
                     end
                  else Flag:=True
              Else Flag:=False;
              CStr:=Flag;
         end;

Procedure DelDirFromList(Str:string);
{     }
          Var i:integer;
          begin
               For i:=MF.List.Items.Count-1 downto 0 do
                   begin
                        if CStr(MF.List.Items[i],Str) then
                           begin
                                MF.List.Items.Delete(i);
                                MF.Temp.Items.Delete(i);
                           end;
                   end;
          end;

Procedure CheckDirInDirBox(A:string);
          Var
             i:integer;
          begin
               For i:=0 to DelDir.DirBox.Items.Count-1 do
                   begin
                        if CStr(DelDir.DirBox.Items[i],A) then
                           DELDir.DirBox.Checked[i]:=True;
                   end;
          end;

procedure TDelDir.S1Click(Sender: TObject);
Var i:integer;
begin
     For i:=0 to DirBox.Items.Count-1 do
         begin
              if DirBox.Checked[i] then
                 begin
                      CheckDirInDirBox(DirBox.Items[i]);
                      DelDirFromList(DirBox.Items[i]);
                 end;
         end;
     DelDir.DirBox.Clear;
     DelDir.Close;
end;

procedure TDelDir.FormResize(Sender: TObject);
begin
     S1.Width:=FloatToInt(DelDir.Width/2);
     S2.Width:=FloatToInt(DelDir.Width/2);
end;

procedure TDelDir.DirBoxKeyPress(Sender: TObject; var Key: Char);
begin
     if Key=#27 then S2Click(Sender);
     if Key=#13 then S1Click(Sender);
end;

procedure TDelDir.DirBoxClick(Sender: TObject);
Var i:integer;Flag:boolean;
begin
     for i:=0 to DirBox.Items.Count-1 do
         if DirBox.Checked[i] then
            begin
                 Flag:=True;
                 Break;
            end
         Else Flag:=False;
     S1.Enabled:=Flag;
end;
end.
