unit UAttrFilesForm;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Buttons, ExtCtrls;

type
  TAttrFileForm = class(TForm)
    Panel2: TPanel;
    Panel3: TPanel;
    BitBtn1: TBitBtn;
    BitBtn2: TBitBtn;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    RO: TCheckBox;
    Arch: TCheckBox;
    H: TCheckBox;
    Sys: TCheckBox;
    LTime: TLabel;
    LData: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    procedure FormActivate(Sender: TObject);
    procedure ROClick(Sender: TObject);
    procedure ArchClick(Sender: TObject);
    procedure HClick(Sender: TObject);
    procedure SysClick(Sender: TObject);
    procedure BitBtn1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  AttrFileForm: TAttrFileForm;
  FileAttrName: TSearchRec;

Procedure SetColorLabel(CB:TCheckBox;CLabel:TLabel);
implementation
Uses UMainForm,FMXUtils;

{$R *.DFM}
Procedure SetColorLabel(CB:TCheckBox;CLabel:TLabel);
          begin
               if CB.Checked then
                  CLabel.Font.Color:=ClBlue
               else
                   CLabel.Font.Color:=ClBlack;
               end;

function FindSelFile:string;
         Var
            i:integer;
         begin
              for i:=0 to MainForm.FileList.Items.Count-1 do
                  begin
                       if MainForm.FileList.Selected[i] then
                          FindSelFile:=MainForm.FileList.Items[i]
                  end;
         end;

procedure TAttrFileForm.FormActivate(Sender: TObject);

begin
     RO.Checked:=False;
     H.Checked:=False;
     Arch.Checked:=False;
     Sys.Checked:=False;
     If MainForm.FileList.SelCount=1 then
        begin
     FindFirst(FindSelFile,faAnyFile,FileAttrName);
     AttrFileForm.Caption:='File '+ExtractFileName(FileAttrName.Name);
     LTime.Caption:=TimeToStr(FileDateTime(FileAttrName.Name));
     LData.Caption:=DateToStr(FileDateTime(FileAttrName.Name));
     Case FileAttrName.Attr of
          faReadOnly : begin
                            RO.Checked:=True;
                       end;
          faSysFile : begin
                           Sys.Checked:=True;
                       end;
          faHidden : begin
                           H.Checked:=True;
                       end;
          faArchive : begin
                           Arch.Checked:=True;
                       end;
 faReadOnly+faArchive : begin
                             RO.Checked:=True;
                             Arch.Checked:=True;
                       end;
 faReadOnly+faSysFile : begin
                             RO.Checked:=True;
                             Sys.Checked:=True;
                        end;
 faReadOnly+faHidden : begin
                             RO.Checked:=True;
                             H.Checked:=True;
                        end;
 faArchive+faHidden : begin
                             Arch.Checked:=True;
                             H.Checked:=True;
                        end;
 faArchive+faSysFile : begin
                             Arch.Checked:=True;
                             H.Checked:=True;
                        end;
  faHidden+faSysFile : begin
                             Arch.Checked:=True;
                             H.Checked:=True;
                        end;
  faHidden+faSysFile+faReadOnly : begin
                                       H.Checked:=True;
                                       Sys.Checked:=True;
                                       RO.Checked:=True;
                                  end;
  faHidden+faSysFile+faArchive : begin
                                       H.Checked:=True;
                                       Sys.Checked:=True;
                                       Arch.Checked:=True;
                                  end;
  faHidden+faSysFile+faReadOnly+faArchive : begin
                                                 H.Checked:=True;
                                                 Sys.Checked:=True;
                                                 Arch.Checked:=True;
                                                 RO.Checked:=True;
                                            end;
  end;//Case;
  end//if
         else
  begin
       AttrFileForm.Caption:=IntToStr(MainForm.FileList.SelCount)+' files in '+MainForm.FileList.Directory;
       LTime.Caption:='';
       LData.Caption:='';
       RO.Checked:=False;
       H.Checked:=False;
       Sys.Checked:=False;
       Arch.Checked:=False;
  end;

end;

procedure TAttrFileForm.ROClick(Sender: TObject);
begin
     SetColorLabel(RO,Label1);
end;

procedure TAttrFileForm.ArchClick(Sender: TObject);
begin
     SetColorLabel(Arch,Label2);
end;

procedure TAttrFileForm.HClick(Sender: TObject);
begin
     SetColorLabel(H,Label3);
end;

procedure TAttrFileForm.SysClick(Sender: TObject);
begin
     SetColorLabel(Sys,Label4);
end;

procedure TAttrFileForm.BitBtn1Click(Sender: TObject);
Var
   Attr:integer;
   i:integer;
   F:TSearchRec;
begin
     Attr:=0;
     if RO.Checked then Attr:=Attr+faReadOnly;
     If H.Checked then Attr:=Attr+faHidden;
     if Arch.Checked then Attr:=Attr+faArchive;
     if Sys.Checked then Attr:=Attr+faSysFile;
     For i:=0 to MainForm.FileList.Items.Count-1 do
         begin
              if MainForm.FileList.Selected[i] then
                 begin
                      FindFirst(MainForm.FileList.Items[i],faAnyFile,F);
                      FileSetAttr(F.Name,Attr);
                 end;
         end;
end;

end.
