unit UAskDeleteForm;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Buttons;

type
  TAskDeleteForm = class(TForm)
    DeleteList: TListBox;
    BitBtn1: TBitBtn;
    BitBtn2: TBitBtn;
    Label1: TLabel;
    LFilesCount: TLabel;
    procedure FormActivate(Sender: TObject);
    procedure BitBtn1Click(Sender: TObject);
    procedure BitBtn2Click(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  AskDeleteForm: TAskDeleteForm;
  R,AllFilesFlag:Boolean;

Procedure DeleteCurrentFile(D:String);

implementation

uses UMainForm,UMainForm_, FmxUtils, FileCtrl, UAskDeleteCurrentFile,
     UNotTrivial;

{$R *.DFM}

Procedure DeleteCurrentFile(D:String);
          Var
             F:TSearchRec;
          begin
                  FindFirst(d,faAnyFile,F);
                  Case F.Attr of
                       faReadOnly+faArchive : begin
                                         AskDeleteCurrentFile.FileName.Caption:=F.Name+' have atributes READ ONLY. Do you delete it?';
                                         if not AllFilesFlag then AskDeleteCurrentFile.ShowModal;
                                         if R then
                                            begin
                                                 FileSetAttr(F.Name,faArchive);
                                                 DeleteFile(F.Name);
                                            end;

                                    end;
                       faSysFile+faArchive  : begin
                                         AskDeleteCurrentFile.FileName.Caption:=F.Name+' have atributes System File. Do you delete it?';
                                         AskDeleteCurrentFile.ShowModal;
                                         if not AllFilesFlag then AskDeleteCurrentFile.ShowModal;
                                         if R then
                                            begin
                                                 FileSetAttr(F.Name,faArchive);
                                                 DeleteFile(F.Name);
                                            end;
                                    end;
                       faHidden+faArchive   : begin
                                         AskDeleteCurrentFile.FileName.Caption:=F.Name+' have atributes HIDDEN. Do you delete it?';
                                         AskDeleteCurrentFile.ShowModal;
                                         if not AllFilesFlag then AskDeleteCurrentFile.ShowModal;
                                         if R then
                                            begin
                                                 FileSetAttr(F.Name,faArchive);
                                                 DeleteFile(F.Name);
                                            end;
                                    end;
                  else
                      begin
                           DeleteFile(F.Name);
                      end;
                  end;
          end;

procedure TAskDeleteForm.FormActivate(Sender: TObject);
Var i:integer;
begin
     GetFormToCenter(AskDeleteForm);
     ColDeleteFiles:=0;
     MainForm.TempDelete.Clear;
     for i:=0 to ColAllFiles-1 do
        begin
             if MainForm.FileList.Selected[i] then
                begin
                     ColDeleteFiles:=ColDeleteFiles+1;
                     MainForm.TempDelete.Items.Add(CreateStringForTemp(i));
                end;
        end;

     DeleteList.Items:=MainForm.TempDelete.Items;
     For i:=0 to AskDeleteForm.DeleteList.Items.Count-1 do
         begin
              DeleteList.Items[i]:=ExtractFileName(DeleteList.Items[i]);
         end;
     LFilesCount.Caption:=IntToStr(AskDeleteForm.DeleteList.Items.Count)+' file(s)';
end;

procedure TAskDeleteForm.BitBtn1Click(Sender: TObject);
Var
   i:integer;
   dFile:String;
   F:TSearchRec;
begin
     DeleteFlag:=True;
     begin
          for i:=0 to ColDeleteFiles-1 do
             begin
                  DelOneFile(MainForm.TempDelete.Items[i],All);
             end;
     MainForm.TempDelete.Clear;
     DeleteFlag:=False;
     All:=False;
     No:=False;
     Yes:=False;
     MainForm.FileList.Update;
     AskDeleteForm.Close;
     FindClose(F);
     end;
end;

procedure TAskDeleteForm.BitBtn2Click(Sender: TObject);
begin
     DeleteFlag:=False;
     AskDeleteForm.Close;
     MainForm.TempDelete.Clear;
     MainForm.FileList.Update;
end;

procedure TAskDeleteForm.FormClose(Sender: TObject;
  var Action: TCloseAction);
Var
   i:integer;

begin
end;

end.
